/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.authcode.AuthInternalCodeChangeUtil;
import com.ibm.hwmca.base.bpcrcon.BackupCriticalConsoleData;
import com.ibm.hwmca.base.bpcrcon.BackupException;
import com.ibm.hwmca.base.tsd.TsdSendData;
import com.ibm.hwmca.base.updates.BaseUpdater;
import com.ibm.hwmca.base.updates.ConcurrentUpdatingCheckInterface;
import com.ibm.hwmca.base.updates.MOChangeMgmtInfo;
import com.ibm.hwmca.base.updates.PatchFile;
import com.ibm.hwmca.base.updates.PatchTrace;
import com.ibm.hwmca.base.updates.SingleStepEvent;
import com.ibm.hwmca.base.updates.SingleStepListener;
import com.ibm.hwmca.base.updates.UCConcurrencyInfo;
import com.ibm.hwmca.base.updates.UtilityErrorIds;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.util.IssueCmd;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.MissingDependencyException;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class UpdateUtilities
implements UtilityErrorIds,
UpdaterListener {
    private static final String TRACE_MASKT = "XMCLUTLT";
    private static final String TRACE_MASKF = "XMCLUTLF";
    private static final String TRACE_MASKD = "XMCLUTLD";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");
    public static final int SS_OPERATION_RETRIEVE_AND_APPLY = 0;
    public static final int SS_OPERATION_APPLY = 1;
    public static final int SS_OPERATION_REMOVE = 2;
    private static final boolean SS_CANCEL_ALLOWED = true;
    private static final boolean SS_CANCEL_PROHIBITED = false;
    private static final int SS_STEP_NONE = -1;
    private static final int SS_STEP_VERIFY = 1;
    private static final int SS_STEP_BACKUP = 2;
    private static final int SS_STEP_COMMIT = 3;
    private static final int SS_STEP_IMPORT = 4;
    private static final int SS_STEP_RECALL = 5;
    private static final int SS_STEP_APPLY = 6;
    private static final int SS_STEP_REJECT = 7;
    private static final int SS_STEP_POST_IPL = 8;
    private static final int SS_DURATION_VERIFY = 60;
    private static final int SS_DURATION_BACKUP = 1800;
    private static final int SS_DURATION_COMMIT = 30;
    private static final int SS_DURATION_IMPORT = 1200;
    private static final int SS_DURATION_RECALL = 900;
    private static final int SS_DURATION_APPLY = 900;
    private static final int SS_DURATION_REJECT = 900;
    private static final short ERROR_CHANGE_MANAGEMENT_DISABLED = 50;
    private static final short NO_REMOTE_UPDATES_AVAILABLE = 51;
    public static final int GCI_MODE_APPLY = 1;
    public static final int GCI_MODE_REJECT = 2;
    private LocalizableText message;
    private PanelTaskletProgressListener taskletListener;
    private UpdateManager manager;
    private int processingUpdaters;
    private String inProgressId;
    private boolean remoteMethodFailed;
    private boolean applyOrRejectIsMultiPass;
    private boolean gotUpdateCollections;

    public UpdateUtilities() {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities()");
        this.manager = UpdateManager.getUpdateManager();
        this.processingUpdaters = 0;
        this.inProgressId = null;
        this.applyOrRejectIsMultiPass = false;
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStagedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> applyStagedCollections()");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            List streams = this.manager.getTowerUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            boolean doneWithStreams = false;
            while (!doneWithStreams && counterOfStreams.hasNext()) {
                UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
                int stagedLevel = nextUpdateableComponent.getStagedLevel();
                int appliedLevel = nextUpdateableComponent.getAppliedLevel();
                Trace.trace(TRACE_MASKD, "Component [" + nextUpdateableComponent.getECNumber() + "] stagedLevel=" + stagedLevel + " appliedLevel=" + appliedLevel);
                if (stagedLevel <= 0 || appliedLevel >= stagedLevel) continue;
                UpdateLevel nextLevel = new UpdateLevel(nextUpdateableComponent.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                this.applyStagedCollections(levelsToProcess, false);
            } else {
                FrameworkEventText eventText = new FrameworkEventText(685);
                new SystemEventLog(eventText, "MMCNOINST").log();
                new E4EventLog(eventText, "MMCNOINST").log();
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- applyStagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStagedCollections(List levelsToProcess) throws HException {
        Trace.trace(TRACE_MASKT, "-> applyStagedCollections(List)");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            this.applyStagedCollections(levelsToProcess, true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- applyStagedCollections(List)");
    }

    /*
     * Unable to fully structure code
     */
    private void applyStagedCollections(List levelsToProcess, boolean rejectMultiPass) throws HException {
        Trace.trace("XMCLUTLT", "-> applyStagedCollections(List,boolean)");
        this.applyOrRejectIsMultiPass = false;
        if (levelsToProcess.size() > 0) {
            applySteps = null;
            try {
                applySteps = this.manager.arrangeDependenciesForApply(levelsToProcess);
            }
            catch (MissingDependencyException e) {
                this.logInfo("Cannot apply changes due to missing dependency.", (short)-2300);
            }
            if (rejectMultiPass && applySteps.size() > 1) {
                this.logError("Specific collections selected cannot be applied in one pass.", (short)-2304);
            }
            if (applySteps.size() > 1) {
                this.applyOrRejectIsMultiPass = true;
            }
            collections = new ArrayList<E>();
            if (applySteps.size() == 0) {
                Trace.trace("XMCLUTLF", "arrangeDependencies returns an array of size 0. Not sure what this means.");
            } else {
                collections = (List)applySteps.get(0);
            }
            Trace.trace("XMCLUTLF", "The following updates will be applied in the order listed below:");
            li = collections.listIterator();
            while (li.hasNext()) {
                next = (UpdateCollection)li.next();
                Trace.trace("XMCLUTLF", "   " + next.getUpdateableComponent().getDisplayableId() + "." + next.getDisplayableId());
            }
            counterOfUpdateCollections = collections.listIterator();
            while (counterOfUpdateCollections.hasNext()) {
                nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.next();
                try {
                    nextUpdateCollection.apply();
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace("XMCLUTLF", "The apply of " + nextUpdateCollection.getUpdateableComponent().getDisplayableId() + "." + nextUpdateCollection.getDisplayableId() + " failed. Starting recovery");
                    this.message = nextUpdateCollection.getLastMessage();
                    substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
                    eventText = new FrameworkEventText(578, substText);
                    new SystemEventLog(eventText, "MMCINSTLFAIL").log();
                    new E4EventLog(eventText, "MMCINSTLFAIL").log();
                    this.disableChangeManagementOnError();
                    PatchTrace.createTraceFile();
                    ** while (counterOfUpdateCollections.hasPrevious())
                }
lbl-1000:
                // 1 sources

                {
                    nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.previous();
                    nextUpdateCollection.reject();
                    continue;
                }
lbl44:
                // 1 sources

                throw hexc;
            }
            substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
            eventText = new FrameworkEventText(30, substText);
            new SystemEventLog(eventText, "MMCINSTL").log();
            new E4EventLog(eventText, "MMCINSTL").log();
        }
        Trace.trace("XMCLUTLT", "<- applyStagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAppliedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> commitAppliedCollections()");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            List streams = this.manager.getTowerUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
                int committedLevel = nextUpdateableComponent.getCommittedLevel();
                int appliedLevel = nextUpdateableComponent.getAppliedLevel();
                Trace.trace(TRACE_MASKD, "Component [" + nextUpdateableComponent.getECNumber() + "] committedLevel=" + committedLevel + " appliedLevel=" + appliedLevel);
                if (appliedLevel <= 0 || committedLevel >= appliedLevel) continue;
                UpdateLevel nextLevel = new UpdateLevel(nextUpdateableComponent.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                this.commitAppliedCollections(levelsToProcess);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- commitAppliedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAppliedCollections(List levelsToProcess) throws HException {
        Trace.trace(TRACE_MASKT, "-> commitAppliedCollections(List)");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(3);
            String logInfo = null;
            int lowestLevelToLog = 0;
            int highestLevelToLog = 0;
            if (levelsToProcess.size() > 0) {
                List collections = null;
                try {
                    collections = this.manager.arrangeDependenciesForCommit(levelsToProcess);
                }
                catch (MissingDependencyException e) {
                    this.logInfo("Cannot commit changes due to missing dependency.", (short)-2301);
                }
                Trace.trace(TRACE_MASKF, "The following updates will be committed in the order listed below:");
                ListIterator li = collections.listIterator();
                while (li.hasNext()) {
                    UpdateCollection next = (UpdateCollection)li.next();
                    Trace.trace(TRACE_MASKF, "   " + next.getUpdateableComponent().getDisplayableId() + "." + next.getDisplayableId());
                }
                ListIterator counterOfStreams = levelsToProcess.listIterator();
                while (counterOfStreams.hasNext()) {
                    UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
                    int lastLevelToDo = nextStream.getLevel();
                    String ecNumber = nextStream.getUpdateableComponentECNumber();
                    UpdateableComponent nextUpdateableComponent = this.manager.getComponentByECNumber(ecNumber);
                    if (lastLevelToDo == -1) {
                        lastLevelToDo = nextUpdateableComponent.getAppliedLevel();
                    }
                    collections = nextUpdateableComponent.getUpdateCollections();
                    ListIterator counterOfUpdateCollections = collections.listIterator();
                    boolean done = false;
                    highestLevelToLog = 0;
                    lowestLevelToLog = 1000;
                    while (!done && counterOfUpdateCollections.hasNext()) {
                        UpdateCollection nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.next();
                        if (5 == nextUpdateCollection.getState() && nextUpdateCollection.getId() <= lastLevelToDo) {
                            try {
                                int thisLevel = nextUpdateCollection.getId();
                                if (thisLevel < lowestLevelToLog) {
                                    lowestLevelToLog = thisLevel;
                                }
                                if (thisLevel > highestLevelToLog) {
                                    highestLevelToLog = thisLevel;
                                }
                                nextUpdateCollection.commit();
                                nextUpdateableComponent.getUpdateCollections();
                                counterOfUpdateCollections = collections.listIterator();
                                continue;
                            }
                            catch (HException hexc) {
                                Trace.trace(TRACE_MASKF, "The accept of " + nextUpdateCollection.getUpdateableComponent().getDisplayableId() + "." + nextUpdateCollection.getDisplayableId() + " failed.");
                                this.message = nextUpdateCollection.getLastMessage();
                                String[] substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
                                FrameworkEventText eventText = new FrameworkEventText(583, substText);
                                new SystemEventLog(eventText, "MMCDACCPTAIL").log();
                                new E4EventLog(eventText, "MMCACCPTFAIL").log();
                                throw hexc;
                            }
                        }
                        done = true;
                    }
                    if (highestLevelToLog <= 0) continue;
                    logInfo = null == logInfo ? ecNumber + "." + nf.format(lowestLevelToLog) : logInfo + " " + ecNumber + "." + nf.format(lowestLevelToLog);
                    if (highestLevelToLog == lowestLevelToLog) continue;
                    logInfo = logInfo + "-" + nf.format(highestLevelToLog);
                }
                if (null != logInfo) {
                    String[] substText = new String[]{logInfo};
                    FrameworkEventText eventText = new FrameworkEventText(33, substText);
                    new SystemEventLog(eventText, "MMCACCPT").log();
                    new E4EventLog(eventText, "MMCACCPT").log();
                }
            }
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- commitAppliedCollections()");
    }

    public static void copyFile(String sourceFile, String destinationFile) throws FileNotFoundException, IOException {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.copyFile(" + sourceFile + "," + destinationFile + ")");
        File file1 = new File(sourceFile);
        if (!file1.exists()) {
            throw new FileNotFoundException("File " + file1.getPath() + " not found.");
        }
        file1 = null;
        int dirEnd = destinationFile.lastIndexOf(File.separatorChar);
        String theDir = destinationFile.substring(0, dirEnd);
        PatchFile newDir = new PatchFile(theDir);
        if (!newDir.mkdirs()) {
            String errMsg = "Error creating directory [" + theDir + "] that we are copving the source file to";
            Trace.trace(TRACE_MASKF, "    " + errMsg);
            throw new IOException(errMsg);
        }
        IssueCmd cmd = new IssueCmd();
        String command = "cp " + sourceFile + " " + destinationFile;
        int rc = cmd.execute(command);
        if (0 != rc) {
            throw new IOException("Execution of system command " + command + " failed with a return code of " + rc + ". Command output was: [" + cmd.getErrorOutput() + "].");
        }
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities.copyFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStagedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> deleteStagedCollections()");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            List streams = this.manager.getTowerUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
                int stagedLevel = nextUpdateableComponent.getStagedLevel();
                int appliedLevel = nextUpdateableComponent.getAppliedLevel();
                Trace.trace(TRACE_MASKD, "Component [" + nextUpdateableComponent.getECNumber() + "] stagedLevel=" + stagedLevel + " appliedLevel=" + appliedLevel);
                if (stagedLevel <= 0 || appliedLevel >= stagedLevel) continue;
                UpdateLevel nextLevel = new UpdateLevel(nextUpdateableComponent.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                this.deleteStagedCollections(levelsToProcess);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- deleteStagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStagedCollections(List levelsToProcess) throws HException {
        Trace.trace(TRACE_MASKT, "-> deleteStagedCollections(List)");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(3);
            String logInfo = null;
            int lowestLevelToLog = 0;
            int highestLevelToLog = 0;
            ListIterator counterOfStreams = levelsToProcess.listIterator();
            while (counterOfStreams.hasNext()) {
                UpdateLevel nextStream = (UpdateLevel)counterOfStreams.next();
                int lastLevelToDo = nextStream.getLevel();
                String ecNumber = nextStream.getUpdateableComponentECNumber();
                UpdateableComponent nextUpdateableComponent = this.manager.getComponentByECNumber(ecNumber);
                if (lastLevelToDo == -1 && (lastLevelToDo = nextUpdateableComponent.getAppliedLevel() + 1) == 0) {
                    lastLevelToDo = 1;
                }
                List collections = nextUpdateableComponent.getUpdateCollections();
                Collections.sort(collections, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        UpdateCollection c1 = (UpdateCollection)o1;
                        UpdateCollection c2 = (UpdateCollection)o2;
                        int result = c1.getId() - c2.getId();
                        return result;
                    }
                });
                ListIterator counterOfUpdateCollections = collections.listIterator(collections.size());
                highestLevelToLog = 0;
                lowestLevelToLog = 1000;
                while (counterOfUpdateCollections.hasPrevious()) {
                    UpdateCollection nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.previous();
                    if (1 != nextUpdateCollection.getState() || nextUpdateCollection.getId() < lastLevelToDo) continue;
                    try {
                        int thisLevel = nextUpdateCollection.getId();
                        if (thisLevel < lowestLevelToLog) {
                            lowestLevelToLog = thisLevel;
                        }
                        if (thisLevel > highestLevelToLog) {
                            highestLevelToLog = thisLevel;
                        }
                        nextUpdateCollection.delete();
                    }
                    catch (HException hexc) {
                        Trace.trace(TRACE_MASKF, "The delete of " + nextUpdateCollection.getUpdateableComponent().getDisplayableId() + "." + nextUpdateCollection.getDisplayableId() + " failed.");
                        this.message = nextUpdateCollection.getLastMessage();
                        String[] substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
                        FrameworkEventText eventText = new FrameworkEventText(582, substText);
                        new SystemEventLog(eventText, "MMCDELFAIL").log();
                        new E4EventLog(eventText, "MMCDELFAIL").log();
                        throw hexc;
                    }
                    nextUpdateableComponent.getUpdateCollections();
                    counterOfUpdateCollections = collections.listIterator(collections.size());
                }
                if (highestLevelToLog <= 0) continue;
                logInfo = null == logInfo ? ecNumber + "." + nf.format(lowestLevelToLog) : logInfo + " " + ecNumber + "." + nf.format(lowestLevelToLog);
                if (highestLevelToLog == lowestLevelToLog) continue;
                logInfo = logInfo + "-" + nf.format(highestLevelToLog);
            }
            if (null != logInfo) {
                String[] substText = new String[]{logInfo};
                FrameworkEventText eventText = new FrameworkEventText(194, substText);
                new SystemEventLog(eventText, "MMCDEL").log();
                new E4EventLog(eventText, "MMCDEL").log();
            }
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- deleteStagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRemoteUnstagedCollectionsToMedia(PanelTaskletProgressListener taskletListener, File mountPoint, int mediaType, List rangesRequested, String inProgressId) throws HException {
        Trace.trace(TRACE_MASKT, "-> exportRemoteUnstagedCollectionsToMedia()");
        try {
            Object owner;
            PatchTrace.createTraceFile();
            this.gotUpdateCollections = false;
            if (rangesRequested == null) {
                this.logError("Null list of update ranges received.", (short)-2297);
            }
            Trace.trace(TRACE_MASKD, "rangesRequested.size()=" + rangesRequested.size());
            if (rangesRequested.size() == 0) {
                this.logError("Invalid list of update ranges received.", (short)-2298);
            }
            this.taskletListener = taskletListener;
            this.inProgressId = inProgressId;
            this.remoteMethodFailed = false;
            List owners = this.manager.getTowerUpdatesOwners();
            ArrayList<Updater> updaterList = new ArrayList<Updater>();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                owner = (UpdatesOwner)counterOfOwners.next();
                Collection ownedRanges = this.selectUpdateRangesByOwner((UpdatesOwner)owner, rangesRequested);
                if (ownedRanges.isEmpty()) continue;
                Updater updater = owner.getUpdaterInstance();
                updater.addUpdaterListener(this);
                updaterList.add(updater);
                updater.exportUpdatesToMedia(mountPoint, mediaType, ownedRanges);
            }
            this.processingUpdaters = updaterList.size();
            Trace.trace(TRACE_MASKD, "processingUpdaters=" + this.processingUpdaters);
            while (this.processingUpdaters > 0) {
                try {
                    owner = this;
                    synchronized (owner) {
                        int updaters = this.processingUpdaters;
                        this.wait(3660000L);
                        if (updaters == this.processingUpdaters) {
                            this.logError(this.processingUpdaters + " updaters did not complete.", (short)-2296);
                        } else {
                            Trace.trace(TRACE_MASKD, "One of the updaters has completed. exportingUpdatres=" + this.processingUpdaters);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            ListIterator counterOfUpdaters = updaterList.listIterator();
            while (counterOfUpdaters.hasNext()) {
                Updater nextUpdater = (Updater)counterOfUpdaters.next();
                nextUpdater.removeUpdaterListener(this);
            }
            this.inProgressId = null;
            if (this.remoteMethodFailed) {
                HException hexc = new HException("Retrieve to removable media failed ");
                if (this.message == null) {
                    this.logError("Retrieve from retain failed.", (short)-2295);
                }
                throw hexc;
            }
            if (!this.gotUpdateCollections) {
                this.setLastMessage((short)51);
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- exportRemoteUnstagedCollectionsToMedia()");
    }

    public LocalizableText getLastMessage() {
        LocalizableText message = this.message;
        this.message = null;
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSuggestedUpdateLevelsForMedia(File mountPoint, int mediaType, List componentsRequested) {
        Trace.trace(TRACE_MASKT, "-> getSuggestedUpdateLevelsForMedia()");
        ArrayList<UpdateLevel> updateLevels = new ArrayList<UpdateLevel>();
        try {
            PatchTrace.createTraceFile();
            ListIterator counterOfComponents = componentsRequested.listIterator();
            while (counterOfComponents.hasNext()) {
                String component = (String)counterOfComponents.next();
                UpdateLevel level = new UpdateLevel(component, 1);
                updateLevels.add(level);
            }
            List owners = this.manager.getTowerUpdatesOwners();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                UpdatesOwner owner = (UpdatesOwner)counterOfOwners.next();
                Updater updater = owner.getUpdaterInstance();
                Collection foundLevels = updater.getLatestUpdateLevelsFromMedia(mountPoint, mediaType, componentsRequested);
                Iterator counterOfFoundLevels = foundLevels.iterator();
                while (counterOfFoundLevels.hasNext()) {
                    UpdateLevel foundLevel = (UpdateLevel)counterOfFoundLevels.next();
                    String foundECNumber = foundLevel.getUpdateableComponentECNumber();
                    int foundCollectionLevel = foundLevel.getLevel();
                    boolean foundInOurList = false;
                    ListIterator counterOfOurLevels = updateLevels.listIterator();
                    int index = 0;
                    while (!foundInOurList && counterOfOurLevels.hasNext()) {
                        UpdateLevel ourLevel = (UpdateLevel)counterOfOurLevels.next();
                        String ourECNumber = ourLevel.getUpdateableComponentECNumber();
                        if (ourECNumber.equals(foundECNumber)) {
                            int ourCollectionLevel = ourLevel.getLevel();
                            foundInOurList = true;
                            if (foundCollectionLevel >= ourCollectionLevel) {
                                Trace.trace(TRACE_MASKF, "Updating suggested level from " + ourCollectionLevel + " to " + foundCollectionLevel + 1);
                                ourLevel.setLevel(foundCollectionLevel + 1);
                                updateLevels.remove(index);
                                updateLevels.add(index, ourLevel);
                            }
                        }
                        ++index;
                    }
                }
            }
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- getSuggestedUpdateLevelsForMedia()");
        return updateLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRemoteUnstagedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> importRemoteUnstagedCollections()");
        try {
            FrameworkEventText eventText;
            String[] substText;
            Object owner;
            PatchTrace.createTraceFile();
            this.gotUpdateCollections = false;
            List owners = this.manager.getTowerUpdatesOwners();
            ArrayList<Updater> updaterList = new ArrayList<Updater>();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                owner = (UpdatesOwner)counterOfOwners.next();
                Updater updater = owner.getUpdaterInstance();
                updater.addUpdaterListener(this);
                updaterList.add(updater);
                updater.importAllRemoteUnstagedUpdates(false);
            }
            this.processingUpdaters = updaterList.size();
            Trace.trace(TRACE_MASKD, "processingUpdaters=" + this.processingUpdaters);
            while (this.processingUpdaters > 0) {
                try {
                    owner = this;
                    synchronized (owner) {
                        int updaters = this.processingUpdaters;
                        this.wait(3660000L);
                        if (updaters == this.processingUpdaters) {
                            this.logError(this.processingUpdaters + " updaters did not complete.", (short)-2293);
                            substText = new String[]{"ALL available updates were requested"};
                            eventText = new FrameworkEventText(577, substText);
                            new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                            new E4EventLog(eventText, "MMCRETRIFAIL").log();
                        } else {
                            Trace.trace(TRACE_MASKD, "One of the updaters has completed. exportingUpdatres=" + this.processingUpdaters);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            ListIterator counterOfUpdaters = updaterList.listIterator();
            while (counterOfUpdaters.hasNext()) {
                Updater nextUpdater = (Updater)counterOfUpdaters.next();
                nextUpdater.removeUpdaterListener(this);
            }
            this.inProgressId = null;
            if (this.remoteMethodFailed) {
                HException hexc = new HException("Retrieve from remote support system failed.");
                if (this.message == null) {
                    this.logError("Retrieve from retain failed.", (short)-2292);
                }
                substText = new String[]{"ALL available updates were requested"};
                eventText = new FrameworkEventText(577, substText);
                new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                new E4EventLog(eventText, "MMCRETRIFAIL").log();
                throw hexc;
            }
            if (!this.gotUpdateCollections) {
                this.setLastMessage((short)51);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- importRemoteUnstagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRemoteUnstagedCollections(List levelsRequested) throws HException {
        Trace.trace(TRACE_MASKT, "-> importRemoteUnstagedCollections()");
        try {
            FrameworkEventText eventText;
            String[] substText;
            Object owner;
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            ArrayList<Updater> updaterList = new ArrayList<Updater>();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                owner = (UpdatesOwner)counterOfOwners.next();
                Collection ownedLevels = this.selectUpdateLevelsByOwner((UpdatesOwner)owner, levelsRequested);
                if (ownedLevels.isEmpty()) continue;
                Updater updater = owner.getUpdaterInstance();
                updater.addUpdaterListener(this);
                updaterList.add(updater);
                updater.importRemoteUpdatesThroughLevel(ownedLevels, false);
            }
            this.processingUpdaters = updaterList.size();
            Trace.trace(TRACE_MASKD, "processingUpdaters=" + this.processingUpdaters);
            while (this.processingUpdaters > 0) {
                try {
                    owner = this;
                    synchronized (owner) {
                        int updaters = this.processingUpdaters;
                        this.wait(3660000L);
                        if (updaters == this.processingUpdaters) {
                            this.logError(this.processingUpdaters + " updaters did not complete.", (short)-2293);
                            substText = new String[]{this.convertUpdateListToLogString(levelsRequested)};
                            eventText = new FrameworkEventText(577, substText);
                            new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                            new E4EventLog(eventText, "MMCRETRIFAIL").log();
                        } else {
                            Trace.trace(TRACE_MASKD, "One of the updaters has completed. exportingUpdatres=" + this.processingUpdaters);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            ListIterator counterOfUpdaters = updaterList.listIterator();
            while (counterOfUpdaters.hasNext()) {
                Updater nextUpdater = (Updater)counterOfUpdaters.next();
                nextUpdater.removeUpdaterListener(this);
            }
            this.inProgressId = null;
            if (this.remoteMethodFailed) {
                HException hexc = new HException("Retrieve from remote support system failed.");
                if (this.message == null) {
                    this.logError("Retrieve from remote support system failed.", (short)-2292);
                }
                substText = new String[]{this.convertUpdateListToLogString(levelsRequested)};
                eventText = new FrameworkEventText(577, substText);
                new SystemEventLog(eventText, "MMCRETRIFAIL").log();
                new E4EventLog(eventText, "MMCRETRIFAIL").log();
                throw hexc;
            }
            if (!this.gotUpdateCollections) {
                this.setLastMessage((short)51);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- importRemoteUnstagedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUnstagedCollectionsFromMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> importUnstagedCollectionsFromMedia()");
        try {
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                UpdatesOwner owner = (UpdatesOwner)counterOfOwners.next();
                Updater updater = owner.getUpdaterInstance();
                updater.importAllUnstagedUpdatesFromMedia(mountPoint, mediaType);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- importUnstagedCollectionsFromMedia()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUnstagedCollectionsFromMedia(File mountPoint, int mediaType, List levelsRequested) {
        Trace.trace(TRACE_MASKT, "-> importUnstagedCollectionsFromMedia()");
        try {
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                UpdatesOwner owner = (UpdatesOwner)counterOfOwners.next();
                Collection ownedLevels = this.selectUpdateLevelsByOwner(owner, levelsRequested);
                if (ownedLevels.isEmpty()) continue;
                Updater updater = owner.getUpdaterInstance();
                updater.importUpdatesThroughLevelFromMedia(mountPoint, mediaType, ownedLevels);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- importUnstagedCollectionsFromMedia()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection queryUnstagedUpdatesOnMedia(File mountPoint, int mediaType) {
        Trace.trace(TRACE_MASKT, "-> queryUnstagedUpdatesOnMedia()");
        ArrayList unstagedUpdates = new ArrayList();
        try {
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                UpdatesOwner owner = (UpdatesOwner)counterOfOwners.next();
                Updater updater = owner.getUpdaterInstance();
                Collection updates = updater.listAllUnstagedUpdateFilesOnMedia(mountPoint, mediaType);
                if (updates.isEmpty()) continue;
                unstagedUpdates.addAll(updates);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- queryUnstagedUpdatesOnMedia()");
        return unstagedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection queryUnstagedUpdatesOnMedia(File mountPoint, int mediaType, List levelsRequested) {
        Trace.trace(TRACE_MASKT, "-> queryUnstagedUpdatesOnMedia()");
        ArrayList unstagedUpdates = new ArrayList();
        try {
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            if (owners.isEmpty()) {
                Trace.trace(TRACE_MASKD, "getTowerUpdatesOwners returned empty list");
            }
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                Updater updater;
                Collection updates;
                UpdatesOwner owner = (UpdatesOwner)counterOfOwners.next();
                Collection ownedLevels = this.selectUpdateLevelsByOwner(owner, levelsRequested);
                if (ownedLevels.isEmpty() || (updates = (updater = owner.getUpdaterInstance()).listUpdateFilesThroughLevelOnMedia(mountPoint, mediaType, ownedLevels)).isEmpty()) continue;
                unstagedUpdates.addAll(updates);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- queryUnstagedUpdatesOnMedia()");
        return unstagedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recallRemoteStagedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> recallRemoteStagedCollections()");
        try {
            Object owner;
            PatchTrace.createTraceFile();
            List owners = this.manager.getTowerUpdatesOwners();
            ArrayList<Updater> updaterList = new ArrayList<Updater>();
            ListIterator counterOfOwners = owners.listIterator();
            while (counterOfOwners.hasNext()) {
                owner = (UpdatesOwner)counterOfOwners.next();
                Updater updater = owner.getUpdaterInstance();
                if (!(updater instanceof BaseUpdater)) continue;
                BaseUpdater baseUpdater = (BaseUpdater)updater;
                updater.addUpdaterListener(this);
                int count = baseUpdater.queryAllRecalledUpdates();
                if (0 == count) {
                    updater.removeUpdaterListener(this);
                    continue;
                }
                updaterList.add(updater);
            }
            this.processingUpdaters = updaterList.size();
            Trace.trace(TRACE_MASKD, "processingUpdaters=" + this.processingUpdaters);
            while (this.processingUpdaters > 0) {
                try {
                    owner = this;
                    synchronized (owner) {
                        int updaters = this.processingUpdaters;
                        this.wait(3660000L);
                        if (updaters == this.processingUpdaters) {
                            this.logError(this.processingUpdaters + " updaters did not complete.", (short)-2296);
                        } else {
                            Trace.trace(TRACE_MASKD, "One of the updaters has completed. recallingUpdatres=" + this.processingUpdaters);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            ListIterator counterOfUpdaters = updaterList.listIterator();
            while (counterOfUpdaters.hasNext()) {
                Updater nextUpdater = (Updater)counterOfUpdaters.next();
                nextUpdater.removeUpdaterListener(this);
            }
            this.inProgressId = null;
            if (this.remoteMethodFailed) {
                HException hexc = new HException("Recall of updates failed ");
                if (this.message == null) {
                    this.logError("Retain recall failed.", (short)-2295);
                }
                throw hexc;
            }
            if (!this.gotUpdateCollections) {
                this.setLastMessage((short)51);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- recallRemoteStagedCollections()");
    }

    public Collection selectUpdateLevelsByOwner(UpdatesOwner owner, List requestList) {
        Trace.trace(TRACE_MASKT, "-> selectUpdateLevelsByOwner()");
        boolean gotStreams = true;
        List componentStreams = null;
        Updater updater = owner.getUpdaterInstance();
        ArrayList<UpdateLevel> ownedLevels = new ArrayList<UpdateLevel>();
        try {
            componentStreams = owner.getUpdateableComponents();
        }
        catch (HException hexc) {
            gotStreams = false;
        }
        ListIterator levelIterator = requestList.listIterator();
        while (gotStreams && levelIterator.hasNext()) {
            UpdateLevel nextLevel = (UpdateLevel)levelIterator.next();
            String componentRequested = nextLevel.getUpdateableComponentECNumber();
            Trace.trace(TRACE_MASKD, "Checking if requested component [" + componentRequested + "] is owned by this updater");
            ListIterator componentIterator = componentStreams.listIterator();
            boolean found = false;
            while (!found && componentIterator.hasNext()) {
                UpdateableComponent component = (UpdateableComponent)componentIterator.next();
                String checkComponent = component.getECNumber();
                Trace.trace(TRACE_MASKD, "Comparing to [" + checkComponent + "].");
                if (!componentRequested.equals(checkComponent)) continue;
                found = true;
                Trace.trace(TRACE_MASKF, "Specific import request for component [" + componentRequested + "] added to list");
                ownedLevels.add(nextLevel);
            }
        }
        Trace.trace(TRACE_MASKT, "<- selectUpdateLevelsByOwner()");
        return ownedLevels;
    }

    public Collection selectUpdateRangesByOwner(UpdatesOwner owner, List requestList) {
        Trace.trace(TRACE_MASKT, "-> selectUpdateRangesByOwner()");
        boolean gotStreams = true;
        Object componentStreams = null;
        Updater updater = owner.getUpdaterInstance();
        ArrayList<UpdateRange> ownedRanges = new ArrayList<UpdateRange>();
        ListIterator rangeIterator = requestList.listIterator();
        while (rangeIterator.hasNext()) {
            UpdateRange nextRange = (UpdateRange)rangeIterator.next();
            String componentRequested = nextRange.getUpdateableComponentECNumber();
            Trace.trace(TRACE_MASKD, "Checking if requested component [" + componentRequested + "] is owned by this updater");
            Trace.trace(TRACE_MASKF, "Specific import request for component [" + componentRequested + "] added to list");
            ownedRanges.add(nextRange);
        }
        Trace.trace(TRACE_MASKT, "<- selectUpdateRangesByOwner()");
        return ownedRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectAppliedCollections() throws HException {
        Trace.trace(TRACE_MASKT, "-> rejectAppliedCollections()");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            List streams = this.manager.getTowerUpdateableComponents();
            ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
            ListIterator counterOfStreams = streams.listIterator();
            while (counterOfStreams.hasNext()) {
                UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
                int committedLevel = nextUpdateableComponent.getCommittedLevel();
                int appliedLevel = nextUpdateableComponent.getAppliedLevel();
                Trace.trace(TRACE_MASKD, "Component [" + nextUpdateableComponent.getECNumber() + "] committedLevel=" + committedLevel + " appliedLevel=" + appliedLevel);
                if (appliedLevel <= 0 || committedLevel >= appliedLevel) continue;
                UpdateLevel nextLevel = new UpdateLevel(nextUpdateableComponent.getECNumber(), -1);
                levelsToProcess.add(nextLevel);
            }
            if (levelsToProcess.size() > 0) {
                this.rejectAppliedCollections(levelsToProcess, false);
            } else {
                FrameworkEventText eventText = new FrameworkEventText(686);
                new SystemEventLog(eventText, "MMCNOREMV").log();
                new E4EventLog(eventText, "MMCNOREMV").log();
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- rejectAppliedCollections()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectAppliedCollections(List levelsToProcess) throws HException {
        Trace.trace(TRACE_MASKT, "-> rejectAppliedCollections(List)");
        try {
            PatchTrace.createTraceFile();
            this.ensureChangeManagementIsEnabled();
            this.rejectAppliedCollections(levelsToProcess, true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            PatchTrace.createTraceFile();
            throw throwable;
        }
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- rejectAppliedCollections(List)");
    }

    /*
     * Unable to fully structure code
     */
    private void rejectAppliedCollections(List levelsToProcess, boolean rejectMultiPass) throws HException {
        Trace.trace("XMCLUTLT", "-> rejectAppliedCollections(list,boolean)");
        this.applyOrRejectIsMultiPass = false;
        if (levelsToProcess.size() > 0) {
            rejectSteps = null;
            try {
                rejectSteps = this.manager.arrangeDependenciesForReject(levelsToProcess);
            }
            catch (MissingDependencyException e) {
                this.logInfo("Cannot reject changes due to missing dependency.", (short)-2299);
            }
            if (rejectMultiPass && rejectSteps.size() > 1) {
                this.logError("Specific collections selected cannot be rejected in one pass.", (short)-2303);
            }
            if (rejectSteps.size() > 1) {
                this.applyOrRejectIsMultiPass = true;
            }
            collections = (List)rejectSteps.get(0);
            Trace.trace("XMCLUTLF", "The following updates will be rejected in the order listed below:");
            li = collections.listIterator();
            while (li.hasNext()) {
                next = (UpdateCollection)li.next();
                Trace.trace("XMCLUTLF", "   " + next.getUpdateableComponent().getDisplayableId() + "." + next.getDisplayableId());
            }
            counterOfUpdateCollections = collections.listIterator();
            while (counterOfUpdateCollections.hasNext()) {
                nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.next();
                try {
                    nextUpdateCollection.reject();
                    continue;
                }
                catch (HException hexc) {
                    Trace.trace("XMCLUTLF", "The apply of " + nextUpdateCollection.getUpdateableComponent().getDisplayableId() + "." + nextUpdateCollection.getDisplayableId() + " failed. Starting recovery");
                    this.message = nextUpdateCollection.getLastMessage();
                    substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
                    eventText = new FrameworkEventText(581, substText);
                    new SystemEventLog(eventText, "MMCREMFAIL").log();
                    new E4EventLog(eventText, "MMCREMFAIL").log();
                    this.disableChangeManagementOnError();
                    PatchTrace.createTraceFile();
                    ** while (counterOfUpdateCollections.hasPrevious())
                }
lbl-1000:
                // 1 sources

                {
                    nextUpdateCollection = (UpdateCollection)counterOfUpdateCollections.previous();
                    nextUpdateCollection.apply();
                    continue;
                }
lbl40:
                // 1 sources

                throw hexc;
            }
            substText = new String[]{this.convertUpdateListToLogString(levelsToProcess)};
            eventText = new FrameworkEventText(32, substText);
            new SystemEventLog(eventText, "MMCREM").log();
            new E4EventLog(eventText, "MMCREM").log();
        }
        Trace.trace("XMCLUTLT", "<- rejectAppliedCollections()");
    }

    public int getSingleStepTotalDuration(int request, boolean isRestart, boolean moreToDo) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> getSingleStepTotalDuration()");
        if (0 > request || 2 < request) {
            throw new IllegalArgumentException("Illegal Request Type");
        }
        int duration = this.ssRemainingDuration(1, request, null, isRestart, moreToDo);
        Trace.trace(TRACE_MASKT, "<- getSingleStepTotalDuration()");
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void singleStep(int requestType, SingleStepListener listener, boolean restart, boolean wasMultiPass) throws IllegalArgumentException {
        block57: {
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    Trace.trace(TRACE_MASKT, "-> UpdateUtilities.singleStep()");
                                                    try {
                                                        String noRwCdString;
                                                        PatchTrace.createTraceFile();
                                                        boolean doReject = false;
                                                        boolean doImport = false;
                                                        boolean noRemoteSupport = true;
                                                        boolean fromScheduledOps = false;
                                                        boolean haveRwCd = true;
                                                        boolean moreToDo = true;
                                                        Date start = new Date();
                                                        switch (requestType) {
                                                            case 2: {
                                                                doReject = true;
                                                                break;
                                                            }
                                                            case 0: {
                                                                doImport = true;
                                                            }
                                                            case 1: {
                                                                noRemoteSupport = !this.isRsfAvailable();
                                                                break;
                                                            }
                                                            default: {
                                                                throw new IllegalArgumentException("Illegal Request Type");
                                                            }
                                                        }
                                                        if (null == listener) {
                                                            fromScheduledOps = true;
                                                        }
                                                        if (restart) {
                                                            moreToDo = wasMultiPass;
                                                        }
                                                        if ((noRwCdString = System.getProperty("NO_RW_CD", "FALSE")).equalsIgnoreCase("TRUE")) {
                                                            haveRwCd = false;
                                                        }
                                                        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.singleStep() - noRwCdString = [" + noRwCdString + "] " + "haveRwCd = " + haveRwCd);
                                                        if (!restart) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Verifying");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.verify", 1, requestType, start, true, restart, moreToDo);
                                                            try {
                                                                this.ensureChangeManagementIsEnabled();
                                                            }
                                                            catch (HException he) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure: change management disabled");
                                                                LocalizableText msg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.details.patchNotEnabled");
                                                                this.ssSendErrorMessage(listener, msg);
                                                                Object var19_24 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (doImport && noRemoteSupport) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure: no remote support");
                                                                LocalizableText msg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.details.remoteSupportNotAvailable");
                                                                this.ssSendErrorMessage(listener, msg);
                                                                Object var19_25 = null;
                                                                break block47;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block48;
                                                            }
                                                            if (!doReject && haveRwCd) {
                                                                MediaServicesUtil myMSU = new MediaServicesUtil(null);
                                                                LocalizableText whoIam = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.mediaServices.myName");
                                                                try {
                                                                    myMSU.prepareMedia(6, whoIam, true, "ACTBKP");
                                                                }
                                                                catch (MediaServicesUtilException msue) {
                                                                    LocalizableText msg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.details.mediaNotAvailable");
                                                                    Trace.trace(TRACE_MASKT, "<- singleStep() - failure: media not available");
                                                                    this.ssSendErrorMessage(listener, msg);
                                                                    Object var19_27 = null;
                                                                    PatchTrace.createTraceFile();
                                                                    return;
                                                                }
                                                                try {
                                                                    myMSU.releaseMedia();
                                                                }
                                                                catch (MediaServicesUtilException msue) {
                                                                    Trace.trace(TRACE_MASKF, "<- singleStep() - release media error");
                                                                    Object var19_28 = null;
                                                                    PatchTrace.createTraceFile();
                                                                    return;
                                                                }
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block49;
                                                            }
                                                        }
                                                        if (!restart && haveRwCd && 2 != requestType) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Backup");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.backup", 2, requestType, start, true, restart, moreToDo);
                                                            try {
                                                                BackupCriticalConsoleData bu = new BackupCriticalConsoleData();
                                                                bu.performBackup();
                                                            }
                                                            catch (BackupException be) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - Backup failure");
                                                                this.ssSendErrorMessage(listener, new LocalizableText(be.getMessage()));
                                                                Object var19_30 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block50;
                                                            }
                                                        }
                                                        if (!restart && 2 != requestType) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Committing");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.commit", 3, requestType, start, true, restart, moreToDo);
                                                            try {
                                                                this.commitAppliedCollections();
                                                            }
                                                            catch (HException he) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure");
                                                                this.ssSendErrorMessage(listener, this.getLastMessage());
                                                                Object var19_32 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block51;
                                                            }
                                                        }
                                                        if (!restart && doImport) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Importing");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.import", 4, requestType, start, true, restart, moreToDo);
                                                            try {
                                                                this.importRemoteUnstagedCollections();
                                                            }
                                                            catch (HException he) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure");
                                                                this.ssSendErrorMessage(listener, this.getLastMessage());
                                                                Object var19_34 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block52;
                                                            }
                                                        }
                                                        if (!restart && 2 != requestType) {
                                                            if (!noRemoteSupport) {
                                                                Trace.trace(TRACE_MASKF, "   singleStep(): Recalling");
                                                                this.ssSendInterimMessage(listener, "updates.ssm.progress.recall", 5, requestType, start, true, restart, moreToDo);
                                                                try {
                                                                    this.recallRemoteStagedCollections();
                                                                }
                                                                catch (HException he) {
                                                                    Trace.trace(TRACE_MASKT, "<- singleStep() - failure");
                                                                    this.ssSendErrorMessage(listener, this.getLastMessage());
                                                                    Object var19_36 = null;
                                                                    PatchTrace.createTraceFile();
                                                                    return;
                                                                }
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block53;
                                                            }
                                                        }
                                                        if (2 != requestType && moreToDo) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Applying");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.apply", 6, requestType, start, false, restart, moreToDo);
                                                            try {
                                                                this.applyStagedCollections();
                                                            }
                                                            catch (HException he) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure");
                                                                this.ssSendErrorMessage(listener, this.getLastMessage());
                                                                Object var19_38 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block54;
                                                            }
                                                        }
                                                        if (2 == requestType && moreToDo) {
                                                            Trace.trace(TRACE_MASKF, "   singleStep(): Rejecting");
                                                            this.ssSendInterimMessage(listener, "updates.ssm.progress.reject", 7, requestType, start, false, restart, moreToDo);
                                                            try {
                                                                this.rejectAppliedCollections();
                                                            }
                                                            catch (HException he) {
                                                                Trace.trace(TRACE_MASKT, "<- singleStep() - failure");
                                                                this.ssSendErrorMessage(listener, this.getLastMessage());
                                                                Object var19_40 = null;
                                                                PatchTrace.createTraceFile();
                                                                return;
                                                            }
                                                            if (this.ssWasCanceled(listener)) {
                                                                break block55;
                                                            }
                                                        }
                                                        Trace.trace(TRACE_MASKF, "   singleStep(): Sending TSAD data");
                                                        this.ssSendInterimMessage(listener, "updates.ssm.progress.tsad", 7, requestType, start, false, restart, moreToDo);
                                                        TsdSendData.sendServiceAvailabilityData();
                                                        if (this.ssWasCanceled(listener)) {
                                                            break block56;
                                                        }
                                                        SingleStepEvent sse = new SingleStepEvent(this, new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.progress.completed"), 1);
                                                        listener.operationCompleted(sse);
                                                        break block57;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var19_44 = null;
                                                        PatchTrace.createTraceFile();
                                                        throw throwable;
                                                    }
                                                }
                                                PatchTrace.createTraceFile();
                                                return;
                                            }
                                            Object var19_26 = null;
                                            PatchTrace.createTraceFile();
                                            return;
                                        }
                                        Object var19_29 = null;
                                        PatchTrace.createTraceFile();
                                        return;
                                    }
                                    Object var19_31 = null;
                                    PatchTrace.createTraceFile();
                                    return;
                                }
                                Object var19_33 = null;
                                PatchTrace.createTraceFile();
                                return;
                            }
                            Object var19_35 = null;
                            PatchTrace.createTraceFile();
                            return;
                        }
                        Object var19_37 = null;
                        PatchTrace.createTraceFile();
                        return;
                    }
                    Object var19_39 = null;
                    PatchTrace.createTraceFile();
                    return;
                }
                Object var19_41 = null;
                PatchTrace.createTraceFile();
                return;
            }
            Object var19_42 = null;
            PatchTrace.createTraceFile();
            return;
        }
        Object var19_43 = null;
        PatchTrace.createTraceFile();
        Trace.trace(TRACE_MASKT, "<- singleStep() - normal completion");
    }

    private int ssRemainingDuration(int step, int operation, Date start, boolean isRestart, boolean moreToDo) {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.singleStep()");
        int newDuration = 0;
        if (start != null) {
            Date now = new Date();
            newDuration = (int)((now.getTime() - start.getTime()) / 1000L);
        }
        int verifySeconds = 60;
        int backupSeconds = 1800;
        int commitSeconds = 30;
        int recallSeconds = 900;
        int importSeconds = 1200;
        int applySeconds = 900;
        int rejectSeconds = 900;
        if (isRestart) {
            verifySeconds = 0;
            backupSeconds = 0;
            commitSeconds = 0;
            recallSeconds = 0;
            importSeconds = 0;
        }
        if (!moreToDo) {
            applySeconds = 0;
            rejectSeconds = 0;
        }
        if (2 == operation) {
            if (1 >= step) {
                newDuration += verifySeconds;
            }
            if (7 >= step) {
                newDuration += rejectSeconds;
            }
        } else {
            if (1 >= step) {
                newDuration += verifySeconds;
            }
            if (2 >= step) {
                newDuration += backupSeconds;
            }
            if (3 >= step) {
                newDuration += commitSeconds;
            }
            if (5 >= step) {
                newDuration += recallSeconds;
            }
            if (6 >= step) {
                newDuration += applySeconds;
            }
            if (0 == operation && 4 >= step) {
                newDuration += importSeconds;
            }
        }
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities.singleStep() - new duration = " + newDuration);
        return newDuration;
    }

    private boolean ssWasCanceled(SingleStepListener listener) {
        Trace.trace(TRACE_MASKT, "-> ssWasCanceled()");
        if (null != listener && listener.isCanceled()) {
            LocalizableText msg = new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.progress.canceled");
            SingleStepEvent sse = new SingleStepEvent(this, msg, 3);
            listener.operationCompleted(sse);
            Trace.trace(TRACE_MASKT, "<- ssWasCanceled() - canceled");
            return true;
        }
        Trace.trace(TRACE_MASKT, "<- ssWasCanceled() - continuing");
        return false;
    }

    private void ssSendInterimMessage(SingleStepListener listener, String msgKey, int step, int operation, Date start, boolean canCancel, boolean isRestart, boolean moreToDo) {
        Trace.trace(TRACE_MASKT, "-> ssSendInterimMessage()");
        if (null != listener) {
            LocalizableText msg = new LocalizableText(BaseTextBundle.getBundleName(), msgKey);
            SingleStepEvent sse = new SingleStepEvent(this, msg, 1);
            sse.setDuration(this.ssRemainingDuration(step, operation, start, isRestart, moreToDo));
            sse.setCancelable(canCancel);
            listener.operationProgressing(sse);
        }
        Trace.trace(TRACE_MASKT, "<- ssSendInterimMessage()");
    }

    private void ssSendErrorMessage(SingleStepListener listener, LocalizableText msg) {
        Trace.trace(TRACE_MASKT, "-> ssSendErrorMessage()");
        if (null != listener) {
            SingleStepEvent sse = new SingleStepEvent(this, new LocalizableText(BaseTextBundle.getBundleName(), "updates.ssm.progress.failed"), 2);
            sse.setDetailsMessage(msg);
            listener.operationCompleted(sse);
        }
        HException hexc = new HException(msg.toString());
        new FrameworkLog(logInfo, -2291, hexc).log(FrameworkLogAttributes.INFO_LOG);
        Trace.trace(TRACE_MASKT, "<- ssSendErrorMessage()");
    }

    public static synchronized MOChangeMgmtInfo getConcurrencyInfo(ManagedObject mo, int mode) {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.getConcurrencyInfo(ManagedObject)");
        MOChangeMgmtInfo mocmi = new MOChangeMgmtInfo();
        mocmi.setUpdateTarget(mo);
        mocmi.setMode(mode);
        UpdateManager manager = UpdateManager.getUpdateManager();
        List components = manager.getComponentsByManagedObject(mo);
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.getConcurrencyInfo() - there are " + components.size() + " entries in the list of updateable components for " + mo.getUIInfo().getName());
        if (0 == components.size()) {
            mocmi.setStatus(0);
        } else {
            UCConcurrencyInfo[] ucInfo = new UCConcurrencyInfo[components.size()];
            mocmi.setConcurrencyInfo(ucInfo);
            boolean noChanges = false;
            boolean allConcurrent = false;
            boolean allDisruptive = false;
            boolean someOfEach = false;
            int i = -1;
            Iterator iterator = components.iterator();
            while (iterator.hasNext()) {
                UpdateableComponent uc = (UpdateableComponent)iterator.next();
                Trace.trace(TRACE_MASKF, "   UpdateUtilities.getConcurrencyInfo() - element " + ++i + " is for component " + uc.getDisplayableId());
                ucInfo[i] = UpdateUtilities.extractConcurrencyInfo(uc, mode);
                int tempStatus = ucInfo[i].getStatus();
                Trace.trace(TRACE_MASKD, "   UpdateUtilities.getConcurrencyInfo() - Status from extractConcurrencyInfo() is " + tempStatus + ", flags are (noChanges, allConcurrent, allDisruptive, someOfEach) " + noChanges + ", " + allConcurrent + ", " + allDisruptive + ", " + someOfEach);
                switch (tempStatus) {
                    case 1: {
                        noChanges = true;
                        break;
                    }
                    case 2: {
                        allConcurrent = true;
                        if (!allDisruptive) break;
                        someOfEach = true;
                        break;
                    }
                    case 3: {
                        allDisruptive = true;
                        if (!allConcurrent) break;
                        someOfEach = true;
                        break;
                    }
                    case 4: {
                        someOfEach = true;
                    }
                }
            }
            if (someOfEach) {
                mocmi.setStatus(4);
            } else if (allConcurrent) {
                mocmi.setStatus(2);
            } else if (allDisruptive) {
                mocmi.setStatus(3);
                if (manager.getOwnerForManagedObject(mo) instanceof ConcurrentUpdatingCheckInterface && ((ConcurrentUpdatingCheckInterface)((Object)mo)).isConcurrentUpdatingDisabled()) {
                    mocmi.setStatus(5);
                }
            } else if (noChanges) {
                mocmi.setStatus(1);
            } else {
                mocmi.setStatus(0);
            }
        }
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.getConcurrencyInfo() - Output status is " + mocmi.getStatus() + ", " + "operation mode is " + mocmi.getMode());
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities.getConcurrencyInfo(ManagedObject)");
        return mocmi;
    }

    public static synchronized MOChangeMgmtInfo[] getConcurrencyInfo(ManagedObject[] mo, int mode) {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.getConcurrencyInfo(ManagedObject[])");
        MOChangeMgmtInfo[] mocmi = new MOChangeMgmtInfo[mo.length];
        int i = 0;
        while (i < mo.length) {
            mocmi[i] = UpdateUtilities.getConcurrencyInfo(mo[i], mode);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.getConcurrencyInfo(ManagedObject[])");
        return mocmi;
    }

    public static synchronized UCConcurrencyInfo extractConcurrencyInfo(UpdateableComponent uc, int mode) {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.extractConcurrencyInfo()");
        UCConcurrencyInfo ucInfo = new UCConcurrencyInfo();
        ucInfo.setComponent(uc);
        int stagedLevel = uc.getStagedLevel();
        int appliedLevel = uc.getAppliedLevel();
        int committedLevel = uc.getCommittedLevel();
        int ndApplyLevel = uc.getNonDisruptiveApplyLevel();
        int ndRejectLevel = uc.getNonDisruptiveRejectLevel();
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.extractConcurrencyInfo() - Updateable Component is [" + uc.getDisplayableId() + "], " + "mode is " + mode);
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.extractConcurrencyInfo() - staged level is " + stagedLevel + ", " + "applied level is " + appliedLevel + ", " + "committed level is " + committedLevel);
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.extractConcurrencyInfo() - non-disruptive apply level is " + ndApplyLevel + ", " + "non-disruptive reject level is " + ndRejectLevel);
        if (1 == mode) {
            if (stagedLevel == appliedLevel) {
                ucInfo.setStatus(1);
                ucInfo.setLastConcurrent(-1);
                ucInfo.setFirstDisruptive(-1);
            } else if (0 >= stagedLevel) {
                ucInfo.setStatus(1);
                ucInfo.setLastConcurrent(-1);
                ucInfo.setFirstDisruptive(-1);
            } else if (appliedLevel == ndApplyLevel || -1 == ndApplyLevel) {
                ucInfo.setStatus(3);
                ucInfo.setLastConcurrent(-1);
                ucInfo.setFirstDisruptive(appliedLevel + 1);
            } else if (stagedLevel == ndApplyLevel) {
                ucInfo.setStatus(2);
                ucInfo.setLastConcurrent(stagedLevel);
                ucInfo.setFirstDisruptive(-1);
            } else {
                ucInfo.setStatus(4);
                ucInfo.setLastConcurrent(ndApplyLevel);
                ucInfo.setFirstDisruptive(ndApplyLevel + 1);
            }
        }
        if (2 == mode) {
            if (committedLevel == appliedLevel) {
                ucInfo.setStatus(1);
                ucInfo.setLastConcurrent(-1);
                ucInfo.setFirstDisruptive(-1);
            } else if (-1 == ndRejectLevel) {
                ucInfo.setStatus(3);
                ucInfo.setLastConcurrent(-1);
                ucInfo.setFirstDisruptive(appliedLevel);
            } else if (1 == ndRejectLevel) {
                ucInfo.setStatus(2);
                ucInfo.setLastConcurrent(1);
                ucInfo.setFirstDisruptive(-1);
            } else if (ndRejectLevel == committedLevel + 1) {
                ucInfo.setStatus(2);
                ucInfo.setLastConcurrent(committedLevel + 1);
                ucInfo.setFirstDisruptive(-1);
            } else {
                ucInfo.setStatus(4);
                ucInfo.setLastConcurrent(ndRejectLevel);
                ucInfo.setFirstDisruptive(ndRejectLevel - 1);
            }
        }
        Trace.trace(TRACE_MASKF, "   UpdateUtilities.extractConcurrencyInfo() - Status is " + ucInfo.getStatus() + ", " + "Last concurrent value is " + ucInfo.getLastConcurrent() + ", " + "First disruptive value is " + ucInfo.getFirstDisruptive());
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities.extractConcurrencyInfo()");
        return ucInfo;
    }

    public void disableChangeManagementOnError() {
        Trace.trace(TRACE_MASKD, "-> UpdateUtilities.disableChangeManagementOnError()");
        Runnable disableRunnable = new Runnable(){

            public void run() {
                Trace.trace(UpdateUtilities.TRACE_MASKT, "-> UpdateUtilities.disableRunnable.run()");
                AuthInternalCodeChangeUtil changeAuthUtil = new AuthInternalCodeChangeUtil();
                changeAuthUtil.execute(true, null, null, null);
                Trace.trace(UpdateUtilities.TRACE_MASKT, "<- UpdateUtilities.disableRunnable.run()");
            }
        };
        Thread disableThread = new Thread(disableRunnable, "DisableChangeManagementOnError");
        disableThread.start();
        Trace.trace(TRACE_MASKD, "<- UpdateUtilities.disableChangeManagementOnError()");
    }

    public void ensureChangeManagementIsEnabled() throws HException {
        Trace.trace(TRACE_MASKD, "-> ensureChangeManagementIsEnabled()");
        if (!this.manager.isUpdatingFullyEnabled()) {
            this.setLastMessage((short)50);
            HException hexc = new HException("Change Management Disabled");
            throw hexc;
        }
        Trace.trace(TRACE_MASKD, "<- ensureChangeManagementIsEnabled()");
    }

    public boolean isApplyOrRejectMultiPass() {
        Trace.trace(TRACE_MASKT, "<> isApplyOrRejectMultiPass()");
        return this.applyOrRejectIsMultiPass;
    }

    public boolean isRsfAvailable() {
        Trace.trace(TRACE_MASKD, "<> isRsfAvailable()");
        return this.manager.areAllRemoteSupportSystemsAvailable();
    }

    public boolean isShutdownPending() {
        Trace.trace(TRACE_MASKT, "-> isShutdownPending()");
        boolean shutdownPending = false;
        ShutdownManager manager = ShutdownManager.getShutdownManager();
        List requests = manager.queryDeferredRequests();
        if (requests != null && requests.size() != 0) {
            shutdownPending = true;
        }
        Trace.trace(TRACE_MASKT, "<- isShutdownPending returns " + (shutdownPending ? "true" : "false"));
        return shutdownPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performShutdown() {
        block14: {
            Trace.trace(TRACE_MASKT, "-> performShutdown()");
            if (this.isShutdownPending()) {
                try {
                    ShutdownManager manager = ShutdownManager.getShutdownManager();
                    boolean started = manager.startDeferredRequest();
                    Trace.trace(TRACE_MASKF, "startDeferredRequest returns " + (started ? "true" : "false"));
                    if (!started) break block14;
                    UpdateUtilities updateUtilities = this;
                    synchronized (updateUtilities) {
                        try {
                            Trace.trace(TRACE_MASKF, "Waiting for shutdown to happen");
                            this.wait(60000L);
                        }
                        catch (InterruptedException ie) {
                            Trace.trace(TRACE_MASKF, "Wait has been interrupted.");
                        }
                    }
                }
                catch (ShutdownInProcessException exc) {
                    Trace.trace(TRACE_MASKF, "Shutdown is already in progress");
                    UpdateUtilities started = this;
                    synchronized (started) {
                        try {
                            this.wait(60000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                catch (IllegalStateException exc) {
                    this.logError("Tried to shutdown without a shutdown request.", (short)-2294, exc);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- performShutdown()");
    }

    private void logInfo(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKF, "<> logInfo() - " + errorString);
        HException hexc = new HException(errorString);
        new FrameworkLog(logInfo, errorId, hexc).log(FrameworkLogAttributes.INFO_LOG);
        this.setLastMessage(errorId);
        throw hexc;
    }

    private void logError(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        HException hexc = new HException(errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.setLastMessage(errorId);
        throw hexc;
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        this.setLastMessage(errorId);
        Trace.trace(TRACE_MASKD, "<- logError()");
    }

    protected void setLastMessage(short errorId) {
        String key;
        Trace.trace(TRACE_MASKD, "-> setLastMessage()");
        String bundleName = new String("com/ibm/hwmca/base/res/message");
        switch (errorId) {
            case 50: {
                key = new String("MCL0050");
                break;
            }
            case 51: {
                key = new String("MCL0035");
                break;
            }
            case -2304: 
            case -2303: 
            case -2301: 
            case -2300: 
            case -2299: {
                key = new String("MCL0009");
                break;
            }
            default: {
                key = new String("MCFPATCH");
            }
        }
        this.message = new MessageText(bundleName, key);
        Trace.trace(TRACE_MASKD, "<> setLastMessage() - errorId = " + errorId + ", message key is [" + key + "]");
    }

    private void sleep(int sec) throws HException {
        long msecToWait = sec * 1000;
        while (msecToWait > 0L) {
            long started = System.currentTimeMillis();
            try {
                Thread.sleep(msecToWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            msecToWait -= System.currentTimeMillis() - started;
        }
    }

    public void operationProgressing(UpdaterEvent event) {
        Trace.trace(TRACE_MASKT, "-> operationProgressing()");
        if (this.inProgressId != null) {
            ProgressData data = new ProgressData(event.getMessage(), 300L, 0);
            ProgressUpdateEvent progressEvent = new ProgressUpdateEvent(data, this.inProgressId);
            this.taskletListener.updateProgress(progressEvent);
        }
        Trace.trace(TRACE_MASKT, "<- operationProgressing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationCompleted(UpdaterEvent event) {
        Trace.trace(TRACE_MASKT, "-> operationCompleted()");
        ProgressData data = new ProgressData();
        int eventStatus = event.getCompletionStatus();
        Trace.trace(TRACE_MASKD, "eventStatus=" + eventStatus);
        int completionStatus = 3;
        if (eventStatus == 1) {
            completionStatus = 1;
        }
        if (eventStatus == 2) {
            completionStatus = 3;
        }
        if (eventStatus == 3) {
            completionStatus = 4;
        }
        if (eventStatus == 4) {
            completionStatus = 2;
        }
        Trace.trace(TRACE_MASKD, "completionStatus=" + completionStatus);
        if (completionStatus == 3) {
            this.remoteMethodFailed = true;
            this.message = event.getMessage();
            Trace.trace(TRACE_MASKF, "Failure message = " + this.message);
        } else {
            List collections = event.getImportedUpdateCollections();
            if (collections != null && collections.size() > 0) {
                this.gotUpdateCollections = true;
            }
            if ((collections = event.getExportedUpdateCollections()) != null && collections.size() > 0) {
                this.gotUpdateCollections = true;
            }
        }
        if (this.inProgressId != null) {
            data.setCompletionStatus(completionStatus);
            ProgressUpdateEvent progressEvent = new ProgressUpdateEvent(data, this.inProgressId);
            this.taskletListener.updateProgress(progressEvent);
        }
        UpdateUtilities updateUtilities = this;
        synchronized (updateUtilities) {
            --this.processingUpdaters;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- operationCompleted()");
    }

    public static void readFully(BufferedInputStream instream, byte[] buffer) throws IOException {
        UpdateUtilities.readFully(instream, buffer, buffer.length);
    }

    public static void readFully(BufferedInputStream instream, byte[] buffer, int numberOfBytes) throws IOException {
        Trace.trace(TRACE_MASKT, "-> readFully()");
        int allBytesRead = 0;
        while (allBytesRead < numberOfBytes) {
            int bytesRead = instream.read(buffer, allBytesRead, numberOfBytes - allBytesRead);
            allBytesRead += bytesRead;
            Trace.trace(TRACE_MASKD, "<- read() read " + bytesRead + " bytes.");
        }
        Trace.trace(TRACE_MASKT, "<- readFully() read " + allBytesRead + " bytes.");
    }

    public String convertUpdateListToLogString(List levelsToProcess) {
        Trace.trace(TRACE_MASKT, "-> UpdateUtilities.convertUpdateListToLogString()");
        String logInfo = null;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        ListIterator counterOfStreams = levelsToProcess.listIterator();
        while (counterOfStreams.hasNext()) {
            UpdateLevel thisStream = (UpdateLevel)counterOfStreams.next();
            String ecNumber = thisStream.getUpdateableComponentECNumber();
            int level = thisStream.getLevel();
            String levelStr = "";
            levelStr = -1 == level ? "ALL" : nf.format(level);
            logInfo = null == logInfo ? ecNumber + "." + levelStr : logInfo + " " + ecNumber + "." + levelStr;
        }
        if (null == logInfo) {
            logInfo = "";
        }
        Trace.trace(TRACE_MASKT, "<- UpdateUtilities.convertUpdateListToLogString() - [" + logInfo + "]");
        return logInfo;
    }
}

